/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: dospath.c,v 1.1 1997/01/20 22:57:54 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include "dospath.h"

char *
catpath(char *dest, char *pos, const char *src)
{
    return strcpy(addslash(dest, strrchr(pos, 0)), src);
}

char *
cutpath(char *dest, char *pos)
{
    *chkslash(dest, pos) = 0;
    return stripath(dest);
}

char *
stripath(const char *path)
{
    char *pos;

    if ((pos = strrchr(path, '/')) == NULL)
	pos = strchr(path, ':');
    if (pos && pos[1])
	pos++;
    else
	pos = (char *) path;
    return pos;
}

char *
fixslash(char *path)
{
    char *p;

    for (p = path; (p = strchr(p, '\\')) != NULL; p++)
	*p = '/';
    return path;
}

char *
addslash(char *path, char *pos)
{
    if (pos > path && *(pos - 1) != '/' && *(pos - 1) != ':')
	*pos++ = '/';
    return pos;
}

char *
chkslash(char *path, char *pos)
{
    if (pos > path + 1 && *(pos - 1) == '/' && *(pos - 2) != ':')
	pos--;
    return pos;
}
