/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: fts.h,v 1.1 1997/01/20 22:57:21 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FTS_H
#define FTS_H

#include <dos.h>
#include <bsddef.h>

#define FTS_ROOTLEVEL  0	/* fts_level: base level */
#define FTS_LOGICAL    1	/* fts_open option */
#define FTS_SKIP       2	/* fts_set option */
#define FTS_D          3	/* fts_info: directory (pre-order) */
#define FTS_DC         4	/* fts_info: compatibility only */
#define FTS_DNR        5	/* fts_info: directory not readable */
#define FTS_DP         6	/* fts_info: directory (post-order) */
#define FTS_ERR        7	/* fts_info: error */
#define FTS_F          8	/* fts_info: regular file */
#define FTS_NS         9	/* fts_info: no status */

#define FTS_LEVELS    17	/* levels supported */

typedef struct {
    char *fts_path;		/* full path */
    char *fts_name;		/* name only */
    int fts_errno;		/* errno if error */
    int fts_set;		/* fts_set() options */
    short fts_level;		/* traversal depth */
    u_short fts_info;		/* result code */
} FTSENT;

typedef struct {
    FTSENT ent;			/* associated FTSENT */
    struct _find_t ff[FTS_LEVELS];	/* for _dos_findnext */
    char path[204];		/* path found */
    char *const * argv;		/* arguments to fts_open */
} FTS;

FTS *fts_open(char *const * path_argv, int options, void *unused);
FTSENT *fts_read(FTS * ftsp);
int fts_set(FTS * ftsp, FTSENT * f, int options);
int fts_close(FTS * ftsp);

#endif
